;Listing1.asm - DOSDEMO.ASM
   section  text,code      ;for PHXASS assembler
openlibrary    =  -552     ;exec routines
closelibrary   =  -414
output         =  -60      ;dos routines
write          =  -48

start:
   move.l   sp,stack       ;save the sp
   movea.l  4,a6           ;exec location
   lea      dos,a1         ;dos name
   moveq    #0,d0          ;any version
   jsr      openlibrary(a6)
   move.l   d0,dosbase     ;save dos address
   beq.s    done           ; or branch if none
   movea.l  d0,a6
   jsr      output(a6)     ;get conhandle
   move.l   d0,conhandler  ;save address

fillbuffer:
   move.l   dosbase,d0     ;dos address
   lea      buffer,a0      ;our storage area
   moveq    #0,d2          ;clear
   moveq    #0,d3          ;clear character counter
more
   rol.l    #4,d0          ;rotate left 4 times
   move.l   d0,d2          ;save changes
   andi.b   #$f,d2         ;get 0 - 15
   addi.b   #$30,d2        ;chr$ values
   cmpi.b   #'9',d2        ;is it 0 - 9
   bls.s    ok             ; it is
   addq.b   #7,d2          ;make it A - F
ok
   move.b   d2,(a0)+       ;save,increase buffer
   addq.l   #1,d3          ;increase counter
   cmpi.l   #8,d3          ;done 8 yet
   bne.s    more           ; branch if not

printlib:
   move.l   conhandler,d1  ;output buffer
   move.l   #buffer,d2     ;input buffer
   addq.w   #1,d3          ;also printing a linefeed
   jsr      write(a6)      ;print our buffer

closeout:
   movea.l  a6,a1          ;dos address
   movea.l  4,a6
   jsr      closelibrary(a6)
done
   movea.l  stack,sp       ;restore the stack
   rts                     ;return to cli
   even                    ;force to long word address

storage:
stack       dc.l  0
dosbase     dc.l  0
conhandler  dc.l  0
buffer      ds.b  8        ;8 bytes
            dc.b  10       ; plus linefeed
   even
dos         dc.b  'dos.library',0
   end


